<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataprocMetastore;

class MigrationExecution extends \Google\Model
{
  protected $cloudSqlMigrationConfigType = CloudSQLMigrationConfig::class;
  protected $cloudSqlMigrationConfigDataType = '';
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $endTime;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $phase;
  /**
   * @var string
   */
  public $state;
  /**
   * @var string
   */
  public $stateMessage;

  /**
   * @param CloudSQLMigrationConfig
   */
  public function setCloudSqlMigrationConfig(CloudSQLMigrationConfig $cloudSqlMigrationConfig)
  {
    $this->cloudSqlMigrationConfig = $cloudSqlMigrationConfig;
  }
  /**
   * @return CloudSQLMigrationConfig
   */
  public function getCloudSqlMigrationConfig()
  {
    return $this->cloudSqlMigrationConfig;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setPhase($phase)
  {
    $this->phase = $phase;
  }
  /**
   * @return string
   */
  public function getPhase()
  {
    return $this->phase;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param string
   */
  public function setStateMessage($stateMessage)
  {
    $this->stateMessage = $stateMessage;
  }
  /**
   * @return string
   */
  public function getStateMessage()
  {
    return $this->stateMessage;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MigrationExecution::class, 'Google_Service_DataprocMetastore_MigrationExecution');
